<?php
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * questo codice costruisce il pannello laterale di Geecom:
    * fa una query per vedere quali componenti sono attivi e li stampa nell'ordine prescelto
    * dall'utente
    */

    class VisualizzatorePannelloLaterale {
  
        static function stampa($geecomDb, $impostazioniAspetto, $configurazioneColore, $colonna,$lingua) {
            
            $queryComponentiDaMostrare = "SELECT cp.*, c.nome FROM geecB_composizionePannelloLaterale AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.nomePannello LIKE '$colonna' ORDER BY posizione ASC";
            $colonnaLetteraMaiuscola   = ucfirst($colonna);
            echo"<div class=\"colonnaSecondaria {$configurazioneColore["colonna$colonnaLetteraMaiuscola"]}\">";
            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
            while($componente = $risComponenti->fetch_assoc()) {
                
                if($componente["nome"]=="Ultimi articoli") {
                    VisualizzatorePannelloLaterale::stampaUltimiArticoli($geecomDb,5,$componente["nomeDaMostrare"],$impostazioniAspetto,$configurazioneColore["aspettoComponentiLaterali"],$lingua);
                }
                else if($componente["nome"]=="Profili social") {
                    VisualizzatorePannelloLaterale::stampaProfiliSocial($geecomDb,$componente["nomeDaMostrare"]);
                }
                else if($componente["nome"]=="Categorie") {
                    VisualizzatorePannelloLaterale::stampaCategorie($geecomDb,$componente["nomeDaMostrare"],$impostazioniAspetto);
                }
                else if($componente["nome"]=="Categorie ecommerce") {
                    VisualizzatorePannelloLaterale::stampaCategorie($geecomDb,$componente["nomeDaMostrare"],$impostazioniAspetto,"ecommerce");
                }
                else if($componente["nome"]=="Tag") {
                    VisualizzatorePannelloLaterale::stampaTag($geecomDb,$componente["nomeDaMostrare"]);
                }
                else if($componente["nome"]=="Banner") {
                    VisualizzatorePannelloLaterale::stampaBannerLaterale($geecomDb,$componente);
                }
                else if($componente["nome"]=="Articoli piu letti") {
                    VisualizzatorePannelloLaterale::stampaArticoliPiuLetti($geecomDb,5,$componente["nomeDaMostrare"],$impostazioniAspetto,$configurazioneColore["aspettoComponentiLaterali"],$lingua);
                }
                else if($componente["nome"]=="Ultime gallerie") {
                    VisualizzatorePannelloLaterale::stampaUltimeGallerie($geecomDb,5,$componente["nomeDaMostrare"],$impostazioniAspetto,$configurazioneColore["aspettoComponentiLaterali"],$lingua);
                }
                else if($componente["nome"]=="Form ricerca") {
                    VisualizzatorePannelloLaterale::stampaFormRicerca($componente["nomeDaMostrare"]);
                }
                else if($componente["nome"]=="HTML") {
                    VisualizzatorePannelloLaterale::stampaCodiceHtmlALato($geecomDb,$componente);
                }
                else if($componente["nome"]=="Testo") {
                    VisualizzatorePannelloLaterale::stampaTestoPersonalizzato($geecomDb,$componente);
                }
                else if($componente["nome"]=="Menu") {
                    VisualizzatorePannelloLaterale::stampaMenuLaterale($geecomDb,$componente,$lingua);
                }
                else if($componente["nome"]=="Categoria in evidenza") {
                    VisualizzatorePannelloLaterale::stampaArticoliCategoria($geecomDb,5,$componente,$impostazioniAspetto,$configurazioneColore["aspettoComponentiLaterali"]);
                }
                else if($componente["nome"]=="Elenco marche prodotti") {
                    VisualizzatorePannelloLaterale::stampaMarcheProdotti($geecomDb,$componente["nomeDaMostrare"],$impostazioniAspetto);
                }
                else if($componente["nome"]=="Ultimi prodotti inseriti") {
                    VisualizzatorePannelloLaterale::stampaUltimiProdotti($geecomDb,5,$componente["nomeDaMostrare"],$impostazioniAspetto,$configurazioneColore["aspettoComponentiLaterali"],$lingua);
                }
                else { //se arriva qui il componente è "Ultime risorse"
                    VisualizzatorePannelloLaterale::stampaUltimeRisorse($geecomDb,5,$componente["nomeDaMostrare"]);
                }
            }
            echo"</div>";
        }
    
        static function stampaUltimiArticoli($geecomDb,$num,$nomeDaMostrare,$impostazioni,$aspettoComponentiLaterali,$lingua) {
            $dataOggi = date("Y-m-d H:i");
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            $queryArticoli = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND stato LIKE 'pubblicato' AND linguaContenuto = '$lingua' AND dataPubblicazione < '$dataOggi' ORDER BY dataPubblicazione DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryArticoli);

            echo"<div class=\"list-group\">\n";
            while($articolo=$result->fetch_assoc()) {
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                if($aspettoComponentiLaterali=="linkEimmagini") {
                    VisualizzatorePannelloLaterale::stampaLinkArticoliConImmagine($articolo,$linkArticolo);
                }
                else {
                    VisualizzatorePannelloLaterale::stampaLinkArticoli($articolo,$linkArticolo);
                }
            }
            echo"</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaArticoliPiuLetti($geecomDb,$num,$nomeDaMostrare,$impostazioni,$aspettoComponentiLaterali,$lingua) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            $queryArticoli = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND linguaContenuto LIKE '$lingua' AND stato LIKE 'pubblicato' ORDER By numeroVisite DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryArticoli);

            echo"<div class=\"list-group\">\n";
            while($articolo=$result->fetch_assoc()) {
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                if($aspettoComponentiLaterali=="linkEimmagini") {
                    VisualizzatorePannelloLaterale::stampaLinkArticoliConImmagine($articolo,$linkArticolo);
                }
                else {			
                    VisualizzatorePannelloLaterale::stampaLinkArticoli($articolo,$linkArticolo);
                }
            }
            echo"</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaArticoliCategoria($geecomDb,$num,$componente,$impostazioni,$aspettoComponentiLaterali) {
            $categoria = $geecomDb->leggiSingolaRiga("geec_categorie",$componente["idElemento"]);

            VisualizzatorePannelloLaterale::creaPannello($componente["nomeDaMostrare"]);
            $queryArticoli = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND stato LIKE 'pubblicato' AND categoria LIKE '{$categoria["id"]}' ORDER By id DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryArticoli);

            echo"<div class=\"list-group\">\n";
            while($articolo=$result->fetch_assoc()) {
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                if($aspettoComponentiLaterali=="linkEimmagini") {
                    VisualizzatorePannelloLaterale::stampaLinkArticoliConImmagine($articolo,$linkArticolo);
                }
                else {			
                    VisualizzatorePannelloLaterale::stampaLinkArticoli($articolo,$linkArticolo);
                }
            }
            echo"</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaFormRicerca($nomeDaMostrare) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            include "template/include/componenti/formRicerca.php";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaCategorie($geecomDb,$nomeDaMostrare,$impostazioni,$tipo="categoriaArticolo") {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare,"elencoCategorie");
            $queryCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre=0 ORDER BY posizione ASC";
            $result = $geecomDb->eseguiQueryLettura($queryCategorie);
            while($categoria = $result->fetch_array()) {
                echo"<div class=\"card rounded-0\">\n";
                echo"<div class=\"card-header py-2 px-3\">";
                $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                echo"<a href=\"$linkCategoria\"> ".$categoria['nome']."</a>";
                $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                $resultSottoCategorie = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                if($resultSottoCategorie->num_rows>0) {
                    echo"<a data-toggle=\"collapse\" data-target=\"#listaSottocategorie{$categoria["id"]}\" aria-expanded=\"true\" aria-controls=\"listaSottocategorie1\" href=\"#\"> <i class=\"fas rotate fa-angle-down fa-pull-right text-muted\"></i> </a>";
                    echo"</div>"; // chiudo il div card-header
                    echo"<div class=\"collapse\" id=\"listaSottocategorie{$categoria["id"]}\">";
                    echo"<ul class=\"list-group list-group-flush\">";
                    while($sottoCategoria = $resultSottoCategorie->fetch_array()) {
                        $linkSottoCategoria = GeneratoreUrl::creaUrlCategoria($sottoCategoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                        echo"<li class=\"list-group-item list-group-item-action small\">"
                        . "<a href=\"$linkSottoCategoria\">{$sottoCategoria["nome"]}</a>"
                        . "</li>";
                    }
                    echo"</ul>"
                    . "</div>";
                }
                else {
                    echo"</div>"; // chiudo il div card-header
                }
                echo"</div>"; // chiudo il div card rounded, questo è uguale per tutti
            }
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaTag($geecomDb,$nomeDaMostrare) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare,"tag-cloud");
            $queryCategorie = "SELECT * FROM geec_tag";
            $result = $geecomDb->eseguiQueryLettura($queryCategorie);
            while($tag = $result->fetch_array()) {
                echo"<a href=\"cerca.php?tipoRicerca=tag&chiaveRicerca=".$tag['nome']."\" class=\"badge badge-primary p-2\">".$tag['nome']."</a>";
            }
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        // funzione che stampa l'immagine laterale, che si può impostare tramite il componente 
        // immagine laterale
        // in questo caso la variabile $nomeDaMostrare 
        static function stampaBannerLaterale($geecomDb,$componente) {
            VisualizzatorePannelloLaterale::creaPannello($componente["nomeDaMostrare"]);
            if($componente["idElemento"]>0) {
                $datiBanner = $geecomDb->leggiSingolaRiga("geec_banner",$componente["idElemento"]);

                $queryCampagnaAttiva = "SELECT * FROM geec_campagneBanner WHERE idBanner = {$datiBanner["id"]} AND attiva LIKE 'si' LIMIT 1";
                $risCampagna = $geecomDb->eseguiQueryLettura($queryCampagnaAttiva);
                if($risCampagna->num_rows>0) {
                    $datiCampagna= $risCampagna->fetch_assoc();                    
                    echo"<div class=\"{$datiCampagna["spazioOccupato"]} d-none d-sm-block\">
                                <a href=#  onclick=gestisciClick({$datiCampagna["id"]},'{$datiCampagna["link"]}','incrementaClickBanner')>
                                    <img class=\"img-fluid\" src=\"{$datiCampagna["immagine"]}\" >
                                </a>
                            </div>

                            <div class=\"col d-sm-none\">
                                <a href=#  onclick=\"gestisciClick({$datiCampagna["id"]},'{$datiCampagna["link"]}','incrementaClickBannerMobile')\">
                                    <img class=\"img-fluid\" src=\"{$datiCampagna["immagineMobile"]}\" >
                                </a>
                            </div>";
                }
                else {
                    VisualizzatorePannelloLaterale::messaggioDiErrore("Errore: il banner non ha campagne attive");
                }
            }
            else {
                VisualizzatorePannelloLaterale::messaggioDiErrore("Errore di configurazione");
            }
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        // funzione che stampa un codice html personalizzato nella colonna laterale, 
        // queste voci si possono impostare in amministrazione nella sezione componenti
        static function stampaCodiceHtmlaLato($geecomDb,$componente) {
            
            if($componente["nomeDaMostrare"]=="") {
                echo"{$componente["testo"]}";
            }
            else {
                VisualizzatorePannelloLaterale::creaPannello($componente["nomeDaMostrare"]);
                echo"{$componente["testo"]}";
                VisualizzatorePannelloLaterale::chiudiPannello();
            }
        }

        // funzione che stampa un testo personalizzato nella colonna laterale, 
        static function stampaTestoPersonalizzato($geecomDb,$componente) {
            if($componente["nomeDaMostrare"]=="") {
                echo"{$componente["testo"]}";
            }
            else {
                VisualizzatorePannelloLaterale::creaPannello($componente["nomeDaMostrare"]);
                echo"{$componente["testo"]}";
                VisualizzatorePannelloLaterale::chiudiPannello();
            }
        }

        // funzione che stampa il menu laterale impostato dal componente menu laterale 
        static function stampaMenuLaterale($geecomDb,$componente,$lingua) {
            $personalizzazioniMenu = array(
                'divContenitoreMenu'   => "",
                'classeMenu'   => "list-group",
                'elementoMenu' => "list-group-item",
                'linkMenu'     => "",
                'elementoSottomenu' => "",
                'tipoRicerca' => ""
            );
        
            if($componente["nomeDaMostrare"]=="") {
                creaMenu($geecomDb, $lingua, $personalizzazioniMenu);
            }
            else {
                VisualizzatorePannelloLaterale::creaPannello($componente["nomeDaMostrare"]);
                creaMenu($geecomDb, $lingua, $personalizzazioniMenu);
                VisualizzatorePannelloLaterale::chiudiPannello();
            }
        }

        static function stampaUltimeGallerie($geecomDb,$num,$nomeDaMostrare,$impostazioni,$aspettoComponentiLaterali,$lingua) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            $queryGallerie = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'galleria' AND linguaContenuto LIKE '$lingua' ORDER By id DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryGallerie);

            echo"<div class=\"list-group\">\n";
            while($articolo=$result->fetch_assoc()) {
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                if($aspettoComponentiLaterali=="linkEimmagini") {
                    VisualizzatorePannelloLaterale::stampaLinkArticoliConImmagine($articolo,$linkArticolo);
                }
                else {			
                    VisualizzatorePannelloLaterale::stampaLinkArticoli($articolo,$linkArticolo);
                }
            }
            echo"</ul>\n</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        static function stampaUltimeRisorse($geecomDb,$num,$nomeDaMostrare) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            $queryRisorse = "SELECT * FROM geecB_risorse ORDER By id DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryRisorse);

            echo"<div class=\"list-group\">\n";
            while($risorsa=$result->fetch_assoc()) {
                    echo"<div class=\"form-group\">
                         <a class=\"list-group-item\" href=\"scaricaFile.php?id={$risorsa["id"]}\">  <i class=\"glyphicon glyphicon-download\"></i> {$risorsa["nome"]} </a>
                     </div>";
            }
            echo"\n</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }
        
        //componente profiliSocial
        //
        // stampa i link ai profili social presenti. La funzione richiama il file
        // stampaProfili.php che si trova nella cartella del componente profiliSocial
        // ed è lo stesso file che viene richiamato dalla pagina include/creaBarraSuperiore.php
        static function stampaProfiliSocial($geecomDb,$nomeDaMostrare) {
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            include "template/include/componenti/stampaProfiliSocial.php";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }

        /*
         * stampa i link degli articoli senza immagine
         * metodo utilizzato da stampaUltimiArticoli, stampaArticoliPiuLetti e stampaArticoliCategoria
         */
        static function stampaLinkArticoli($articolo,$linkArticolo) {
            echo"<a class=\"list-group-item\" href=\"$linkArticolo\" > ".$articolo['titolo']."</a>";
        }
        
        /*
         * stampa i link degli articoli con una immagine quadrata a lato
         * metodo utilizzato da stampaUltimiArticoli, stampaArticoliPiuLetti e stampaArticoliCategoria
         */
        static function stampaLinkArticoliConImmagine($articolo,$linkArticolo) {
            echo"<a href=\"$linkArticolo\" class=\"list-group-item list-group-item-action p-0 rounded-0\">
                <div class=\"media border-0 m-0\">
                    <div class=\"m-0 background-image border-0\" style=\"background-image: url('{$articolo['foto']}')\"></div>
                      <div class=\"media-body p-3 m-0\">
                            <h6 class=\"my-0 text-truncate-2\">{$articolo['titolo']}</h6>
                      </div>
                </div>
            </a>";
        }
        
        static function stampaMarcheProdotti($geecomDb,$nomeDaMostrare,$impostazioni) {
            // recupera informazioni passate in input alla pagina in cui è invocato
            $tipoRicerca   = filter_input(INPUT_GET,"tipoRicerca",FILTER_SANITIZE_STRING);
            
            if($tipoRicerca=="categoria" || $tipoRicerca=="prodottiPerMarcaECategoria") {
		    $chiaveRicerca = filter_input(INPUT_GET,"chiaveRicerca",FILTER_SANITIZE_STRING);
		    $categoria     = $geecomDb->leggiSingolaRiga("geec_categorie",$chiaveRicerca,"alias");
                //$linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
		    $queryMarche = "SELECT DISTINCT(marca) FROM geecEc_prodotti WHERE marca NOT LIKE '' AND categoria = {$categoria["id"]}";
		    $linkRicerca = "cerca.php?tipoRicerca=prodottiPerMarcaECategoria&chiaveRicerca={$categoria["alias"]}&marca=";
            }
            else {
		    $queryMarche = "SELECT DISTINCT(marca) FROM geecEc_prodotti WHERE marca NOT LIKE ''";
		    $linkRicerca = "cerca.php?tipoRicerca=cercaProdottiPerMarca&chiaveRicerca=";
            }

            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare,"elencoCategorie");
            $result = $geecomDb->eseguiQueryLettura($queryMarche);
            while($marca = $result->fetch_array()) {
                echo"<div class=\"card rounded-0\">\n";
                echo"<div class=\"card-header py-2 px-3\">";
                echo"<a href=\"$linkRicerca{$marca['marca']}\"> ".$marca['marca']."</a>";
		echo"</div>"; // chiudo il div card-header
                echo"</div>"; // chiudo il div card rounded, questo è uguale per tutti
            }
            VisualizzatorePannelloLaterale::chiudiPannello();
        }
        
        static function stampaUltimiProdotti($geecomDb,$num,$nomeDaMostrare,$impostazioni,$aspettoComponentiLaterali,$lingua) {
            $dataOggi = date("Y-m-d H:i");
            VisualizzatorePannelloLaterale::creaPannello($nomeDaMostrare);
            $queryArticoli = "SELECT * FROM geecEc_prodotti WHERE lingua='$lingua' AND pubblicato LIKE 'si' ORDER BY id DESC LIMIT $num";
            $result = $geecomDb->eseguiQueryLettura($queryArticoli);

            echo"<div class=\"list-group\">\n";
            while($prodotto=$result->fetch_assoc()) {
                $linkArticolo = GeneratoreUrl::creaUrlProdotto($prodotto,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                if($aspettoComponentiLaterali=="linkEimmagini") {
                    VisualizzatorePannelloLaterale::stampaLinkProdottiConImmagine($prodotto,$linkArticolo);
                }
                else {
                    VisualizzatorePannelloLaterale::stampaLinkProdotti($prodotto,$linkArticolo);
                }
            }
            echo"</div>";
            VisualizzatorePannelloLaterale::chiudiPannello();
        }
        
                /*
         * stampa i link degli articoli senza immagine
         * metodo utilizzato da stampaUltimiArticoli, stampaArticoliPiuLetti e stampaArticoliCategoria
         */
        static function stampaLinkProdotti($prodotto,$link) {
            echo"<a class=\"list-group-item\" href=\"$link\" > ".$prodotto['nome']."</a>";
        }
        
        /*
         * stampa i link degli articoli con una immagine quadrata a lato
         * metodo utilizzato da stampaUltimiArticoli, stampaArticoliPiuLetti e stampaArticoliCategoria
         */
        static function stampaLinkProdottiConImmagine($prodotto,$link) {
            echo"<a href=\"$link\" class=\"list-group-item list-group-item-action p-0 rounded-0\">
                <div class=\"media border-0 m-0\">
                    <div class=\"m-0 background-image border-0\" style=\"background-image: url('{$prodotto['immagine']}')\"></div>
                      <div class=\"media-body p-3 m-0\">
                            <h6 class=\"my-0 text-truncate-2\">{$prodotto['nome']}</h6>
                      </div>
                </div>
            </a>";
        }
        
        static function creaPannello($nome, $classe="") {
            echo"<div class=\" mb-5 widget $classe\">\n
                   <h5 class=\"\">$nome</h5>";
        }

        static function chiudiPannello() {
            echo"</div>";
        }
        
        static function messaggioDiErrore($messaggio) {
            echo"<div class=\"alert alert-danger\">$messaggio</div>";
        }
    }
